% generate the DATA FOR AR(1) CASE
% d- sample rate (d out of 10)
% n-subjects
% phi-coefficient for ar(1) model
% L-the total numbers of observations for each subject, 
%i.e. the time units is 1/L in our paper 
function [y,x]=rawdata_quality_time(n,d,phi,L)
J=L/10;%generate J observation for each subject
x=zeros(d*J,n,100);
y=zeros(d*J,n,100);
for j=1:100
for i=1:n
%genenrate an AR(1) realization and randomly select d time points from 10 time points
    ar1(1)=normrnd(0,1/sqrt(1-phi^2));
    for k=2:L
    ar1(k)=phi*ar1(k-1)+normrnd(0,1);
    end
for kk=1:J
    A=randperm(10);
    B(((kk-1)*d+1):((kk-1)*d+d))=(kk-1)*10+sort(A(1:d));
end
x(1:d*J,i,j)=B./L';
y(1:d*J,i,j)=1+0.3.*(B'./L).^0.5+ar1(B)';
end
end
x1=x;
y1=y;
save(['C:\Users\Terry\Desktop\U of M\quality\rawdataic_for_univariate_spc_',num2str(L),'_08n',num2str(n),'_J',num2str(d*J),'time.mat'],'y1','x1')